local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end

function getFloatingYModifier(self)
	return math.sin(GetTime()/(350.0+self.Width))*(15.5+self.Height/10)-self.TweakY
end

function SwitchDirection(self)
	if self.Direction == 0 then
		self.Direction = 1
	else
		self.Direction = 0
	end
	Look(self)
end

function TurnRight(self)
	self.Direction = 1
	Look(self)
end

function TurnLeft(self)
	self.Direction = 0
	Look(self)
end

function Look(self)
	if self.Direction == 0 then
		self.RutharEye.DrawFlags.Mirror = false
		if self.MrHat ~= nil then
			self.MrHat.DrawFlags.Mirror = false
		end
		
	else
		self.RutharEye.DrawFlags.Mirror = true
		if self.MrHat ~= nil then
			self.MrHat.DrawFlags.Mirror = true
		end
	end
end

function isLookingAtClaw(self)
	local claw = GetClaw()
	--if math.abs(self.X - claw.X) <= 64 then -- spot when player is really close
	--	return true
	--end
	if self.X < claw.X then
		if self.Direction == 1 then
			return true
		else
			return false
		end
	else
		if self.Direction == 0 then
			return true
		else
			return false
		end
	end
end

function getDistanceFromClaw(self)
	local claw = GetClaw()
	return math.abs(self.X - claw.X)
end

function getFrontDistance(self)
	if self.Direction == 1 then
		return self.XMax - self.X
	elseif self.Direction == 0 then
		return self.X - self.XMin
	end
end

function getBackDistance(self)
	if self.Direction == 1 then
		return self.X - self.XMin
	elseif self.Direction == 0 then
		return self.XMax - self.X
	end
end

function CalcMaxDistance(self, dir)
	if dir == 0 then
		return self.X - self.XMin
	else
		return self.XMax - self.X
	end
end

function ClawInLOS(self)
	--TextOut(self.sensorLFlag .. ", " .. self.sensorRFlag)
	if _CurrentPowerup[0] == 9911 then --9917
		return false
	elseif self.sensorLFlag == 1 and self.sensorRFlag == 1 then
		local claw = GetClaw()
		--TextOut(self.rangeL .. ", " .. claw.X .. ", " .. self.rangeR)
		--AttackRange = 64 -- Zealot's attack range for purpose of aggro
		if claw.Y > self.Y - 92 and claw.Y < self.Y - 8 and 
			claw.X > self.rangeL and claw.X < self.rangeR and
			claw.X > self.XMin - self.AttackRange and claw.X < self.XMax + self.AttackRange and
			isLookingAtClaw(self) then
			--TextOut(claw.X - self.X)
			return true
		end
		--TextOut(claw.Y - self.Y)
		--if claw.Y > self.Y - 168 and claw.Y < self.Y - 32 and
			--claw.X > self.X - self.AttackRange and claw.X < self.X + self.AttackRange and
			--isLookingAtClaw(self) then
			--
			--return true
		--end
	end
	return false
end

function r()
	return math.floor(rand()*20)-10
end

function SmokeAnimation(self)
	CreateObject {x=self.RutharEye.X, y=self.RutharEye.Y, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 0+r()}
	CreateObject {x=self.RutharEye.X, y=self.RutharEye.Y, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 60+r()}
	CreateObject {x=self.RutharEye.X, y=self.RutharEye.Y, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 120+r()}
	CreateObject {x=self.RutharEye.X, y=self.RutharEye.Y, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 180+r()}
	CreateObject {x=self.RutharEye.X, y=self.RutharEye.Y, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 240+r()}
	CreateObject {x=self.RutharEye.X, y=self.RutharEye.Y, z=4200, name="Smoke", logic="CustomLogic", image="CUSTOM_SMOKE", Counter = 300+r()}
end

function main(self)
	--TextOut(self.Annoyance)
	if self.State == 0 then
		if self.XMin == 0 then
			self.XMin = self.X
		end
		if self.XMax == 0 then
			self.XMax = self.X
		end
		if self.X < self.XMin then
			self.X = self.XMin
		end
		if self.X > self.XMax then
			self.X = self.XMax
		end
		if self.YMin ~= 0 then
			self.Y = self.YMin
		end
		self.MoveRect = {0,0,2,2}
		if self.Smarts == 0 then
			self:AlignToGround()
		end
		self.BaseY = self.Y - 64
		--self.Z = 4001
		self.Width = math.floor(rand()*100)
		self.Height = math.floor(rand()*10)
		self.TweakY = math.floor(rand()*20)
		self.Boredom = 0
		self.Annoyance = 0
		self.Direction = math.floor(rand()+0.5)
		self.LeashLength = self.XMax - self.XMin
		self.XDestination = self.X
		self.SpeedX = 100
		self.rangeL = self.X
		self.rangeR = self.X
		self.cooldown = 1340
		self.lastAttack = GetTime()
		self.AttackRange = 320
		self.LastSeenClawX = nil
		self.AttackObjActive = false
		self.LookAroundsLeft = 3
		self.DrawFlags.NoDraw = true
		self.Achievements = GetObject(4088)
		self.Flag8 = 1
		if self.Speed == 2 then
			self.Flag8 = 0
		end
		if self.Achievements.HardMode == true then
			self.Speed = 2
		end
		
		local img = "CUSTOM_STALKER"
		if self.Speed == 2 then
			img = "CUSTOM_STALKER2"
		end
		self.RutharEye = CreateObject {x=self.X, y=self.BaseY, z=4100, I=1, name="RutharEye", logic="CustomLogic", image=img, SpeedY = self.Y-32, Health = self.Health, UserRect1 = self.UserRect1, UserRect2 = self.UserRect2, Speed = self.Speed, Smarts = self.Smarts}
		self.sensorL = CreateObject {x=self.X, y=self.BaseY-self.Points, z=4100, name="DetectorBullet", logic="CustomLogic", image="LEVEL_WOLVINGTONMAGIC", SpeedX = -1}
		self.sensorR = CreateObject {x=self.X, y=self.BaseY-self.Points, z=4100, name="DetectorBullet", logic="CustomLogic", image="LEVEL_WOLVINGTONMAGIC", SpeedX = 1}
		self.sensorL.DrawFlags.NoDraw = true
		self.sensorR.DrawFlags.NoDraw = true
		self.Flags.AlwaysActive = true
		self.sensorL.Flags.AlwaysActive = true
		self.sensorR.Flags.AlwaysActive = true
		self.sensorLFlag = 0
		self.sensorRFlag = 0
		--GetObject(7098):Destroy()
		self.State = 1
		Look(self)
		self.BoredomTimer = GetTime()
		self.Flag6 = 0
		self.Flag7 = 0
		self.invisFlag = 1
	elseif self.State == 1 then
		if self.RutharEye.State == 1 then -- idle
			if self.Speed == 2 then
				self.RutharEye.DrawFlags.NoDraw = true
				if self.invisFlag == 0 then
					self.invisFlag = 1
					SmokeAnimation(self)
				end
				if self.MrHat ~= nil then
					self.MrHat.DrawFlags.NoDraw = true
				end
			end
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			self.RutharEye.I = 1
			if self.BoredomTimer + 500 < GetTime() then
			--if (GetTime() % 100) == 0 then
				self.BoredomTimer = GetTime()
				self.Boredom = self.Boredom - ( math.ceil(rand()*6)*50+10 )
			end
			if self.Boredom <= 0 then
				self.RutharEye.State = 3
				if self.Annoyance > 1 then
					self.Annoyance = self.Annoyance - 1
				end
			end
		--elseif self.RutharEye.State == 2 then -- taking hit
			--self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			--self.RutharEye.X = self.X
			--self.RutharEye.I = 1
			--if self.RutharEye.TempStunCounter <= GetTime() then
			--	self.RutharEye.State = 1
			--end
			--self.Boredom = 1000
		elseif self.RutharEye.State == 3 then -- wandering decision
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			if self.XMin == self.X and self.XMax == self.X then -- static
				SwitchDirection(self)
				self.Boredom = 1000
				self.RutharEye.State = 1
			end
			if self.X < self.XMin + self.LeashLength*0.3 then
				TurnRight(self)
				self.XDestination = self.X + math.floor(math.sqrt(rand())*CalcMaxDistance(self,1))
					
				self.RutharEye.State = 4
			elseif self.X > self.XMax - self.LeashLength*0.3 then
				TurnLeft(self)
				self.XDestination = self.X - math.floor(math.sqrt(rand())*CalcMaxDistance(self,0))
					
				self.RutharEye.State = 4
			else
				if rand() < 0.5 then
					SwitchDirection(self)
				end
				if self.Direction == 0 then
					self.XDestination = self.X - math.floor(math.sqrt(rand())*CalcMaxDistance(self,0))
				else
					self.XDestination = self.X + math.floor(math.sqrt(rand())*CalcMaxDistance(self,1))
				end
				
				self.RutharEye.State = 4
			end
			if getDistanceFromClaw(self)<400 then
				if rand() > 0.5 then
					PlaySound("CUSTOM_TRIGGER_EYE2MOVE1")
				else
					PlaySound("CUSTOM_TRIGGER_EYE2MOVE2")
				end
			end
		elseif self.RutharEye.State == 4 then -- wandering
			if self.Speed == 2 then
				self.RutharEye.DrawFlags.NoDraw = true
				if self.invisFlag == 0 then
					self.invisFlag = 1
					SmokeAnimation(self)
				end
				self.invisFlag = 1
				if self.MrHat ~= nil then
					self.MrHat.DrawFlags.NoDraw = true
				end
			end
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			self.RutharEye.I = 1
			if self.XDestination == self.X then
				self.Boredom = 1000
				self.RutharEye.State = 1
			end
			if self.XDestination < self.X then
				self.X = self.X - 1
			end
			if self.XDestination > self.X then
				self.X = self.X + 1
			end
		elseif self.RutharEye.State == 6 then -- lost sight of Claw nearby
			if ClawInLOS(self) then
				--self.Boredom = 1000
				self.RutharEye.State = 1
			else
				self.TimeCounter = GetTime()
				self.Annoyance = self.Annoyance + 1
				self.RutharEye.State = 10
				if rand() > 0.5 then
					PlaySound("CUSTOM_TRIGGER_EYE2ANNOYED1")
				else
					PlaySound("CUSTOM_TRIGGER_EYE2ANNOYED2")
				end
			end
		elseif self.RutharEye.State == 10 then -- cartoon looking around
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			if ClawInLOS(self) then
				self.RutharEye.State = 1
			elseif self.LookAroundsLeft <= 0 then
				--SwitchDirection(self)
				self.Boredom = 1000
				self.RutharEye.State = 1
			elseif self.TimeCounter + 2000 < GetTime() then
				SwitchDirection(self)
				self.RutharEye.State = 6
				self.LookAroundsLeft = self.LookAroundsLeft - 1
			end
		elseif self.RutharEye.State == 5 then -- Stalker logic
			local claw = GetClaw()
			self.RutharEye.I = 2
			-- is claw still in sight range?
			if ClawInLOS(self) then
				self.LastSeenClawX = claw.X
				self.TimeCounter = GetTime()
				if self.Annoyance >= 5 then
					self.TimeCounter = self.TimeCounter - 120
				end
				if getDistanceFromClaw(self) >= 168 then
					self.TimeCounter = self.TimeCounter - 150
				end
				self.RutharEye.State = 7
				self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
				self.RutharEye.X = self.X
			else
				--self.RutharEye.State = 1
				self.LookAroundsLeft = 3
				self.RutharEye.State = 6
			end
			
			--if math.abs(self.X - claw.X) <= 64 then
			
			--end
		elseif self.RutharEye.State == 7 then -- charging attack
			if self.Speed == 2 then
				self.RutharEye.DrawFlags.NoDraw = false
				self.invisFlag = 0
				if self.MrHat ~= nil then
					self.MrHat.DrawFlags.NoDraw = false
				end
			end
			if not isLookingAtClaw(self) then
				SwitchDirection(self)
			end
			Look(self)
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			if self.lastAttack + self.cooldown < GetTime() and self.TimeCounter + 300 < GetTime() then
				if ClawInLOS(self) then
					self.RutharEye.State = 8
				else
					self.LookAroundsLeft = 3
					self.RutharEye.State = 6
				end
			else
				local dist = math.abs(self.X - self.LastSeenClawX)
				if dist < self.AttackRange * 0.7 and getBackDistance(self) > 0 then
					-- get away from claw
					if self.LastSeenClawX == nil then
						self.LastSeenClawX = claw.X
					end
					if self.LastSeenClawX < self.X then
						TurnLeft(self)
						if getBackDistance(self) >= 2 then
							self.X = self.X + 1--2
						else
							self.X = self.X + 1
						end
						if self.Speed == 2 and getBackDistance(self) >= 2 then
							self.X = self.X + 2
						elseif dist <= 96 and getBackDistance(self) >= 2 then
							self.X = self.X + 1
						end
					end
					if self.LastSeenClawX > self.X then
						TurnRight(self)
						if getBackDistance(self) >= 2 then
							self.X = self.X - 1--2
						else
							self.X = self.X - 1
						end
						if self.Speed == 2 and getBackDistance(self) >= 2 then
							self.X = self.X - 2
						elseif dist <= 96 and getBackDistance(self) >= 2 then
							self.X = self.X - 1
						end
					end
				elseif dist > self.AttackRange * 0.8 and getFrontDistance(self) > 0 then
					-- get closer to claw
					if self.LastSeenClawX == nil then
						self.LastSeenClawX = claw.X
					end
					if self.LastSeenClawX < self.X then
						TurnLeft(self)
						if getFrontDistance(self) >= 2 then
							self.X = self.X - 1--2
						else
							self.X = self.X - 1
						end
						if self.Speed == 2 and getFrontDistance(self) >= 2 then
							self.X = self.X - 2
						elseif dist <= 96 and getBackDistance(self) >= 2 then
							self.X = self.X - 1
						end
					end
					if self.LastSeenClawX > self.X then
						TurnRight(self)
						if getFrontDistance(self) >= 2 then
							self.X = self.X + 1--2
						else
							self.X = self.X + 1
						end
						if self.Speed == 2 and getFrontDistance(self) >= 2 then
							self.X = self.X + 2
						elseif dist <= 96 and getBackDistance(self) >= 2 then
							self.X = self.X + 1
						end
					end
				end
			end
		
		elseif self.RutharEye.State == 8 then -- attack
			if self.Speed == 2 then
				self.RutharEye.DrawFlags.NoDraw = false
				self.invisFlag = 0
				if self.MrHat ~= nil then
					self.MrHat.DrawFlags.NoDraw = false
				end
			end
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			local claw = GetClaw()
			if self.Speed == 2 and claw.State == 26 then
				--self.bullet = CreateObject {x=self.X + (self.Direction-0.5)*128, y=self.BaseY+8, z=4100, logic="Bullet", image="LEVEL_WOLVINGTONMAGIC", Damage = 10, ObjectTypeFlags = 64, SpeedX = 600*(self.Direction-0.5)}
				self.bullet = CreateObject {x=self.X + (self.Direction-0.5)*128, y=self.BaseY+8, z=4100, name = "StalkerShot", logic="CustomLogic", image="CUSTOM_STALKERSHOT", Damage = 10, ObjectTypeFlags = 64, SpeedX = 600*(self.Direction-0.5)}
			else
				--self.bullet = CreateObject {x=self.X + (self.Direction-0.5)*128, y=self.BaseY-self.Points, z=4100, logic="Bullet", image="LEVEL_WOLVINGTONMAGIC", Damage = 10, ObjectTypeFlags = 64, SpeedX = 600*(self.Direction-0.5)}
				self.bullet = CreateObject {x=self.X + (self.Direction-0.5)*128, y=self.BaseY-self.Points, z=4100, name = "StalkerShot", logic="CustomLogic", image="CUSTOM_STALKERSHOT", Damage = 10, ObjectTypeFlags = 64, SpeedX = 600*(self.Direction-0.5)}
			end
			PlaySound("LEVEL_WOLVINGTON_WMAGIC")
			self.Annoyance = self.Annoyance - 2
			if self.Annoyance < 0 then
				self.Annoyance = 0
			end
			self.AttackObjActive = true
			self.bullet.DrawFlags.Mirror = not self.RutharEye.DrawFlags.Mirror
			self.lastAttack = GetTime()
			--self.TimeCounter = GetTime()
			--self.RutharEye.State = 9
			self.BoredomTimer = GetTime() + 2000
			self.RutharEye.State = 1
		--elseif self.RutharEye.State == 9 then -- after attack
			--self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			--self.RutharEye.X = self.X
			--self.AttackProjectile.Y = self.RutharEye.Y
			--self.RutharEye.State = 1
		elseif self.RutharEye.State == 11 then -- getting hit
			if self.Speed == 2 then
				self.RutharEye.DrawFlags.NoDraw = false
				if self.MrHat ~= nil then
					self.MrHat.DrawFlags.NoDraw = false
				end
			end
			if not isLookingAtClaw(self) then
				self.Achievements.BackStabs = self.Achievements.BackStabs + 1
				self.Annoyance = self.Annoyance + 1
				SwitchDirection(self)
			end
			if ClawInLOS(self) then
				self.RutharEye.State = 1
				self.Annoyance = self.Annoyance + 1
			else
				self.RutharEye.I = 2
				self.LookAroundsLeft = 3
				self.Annoyance = self.Annoyance + 2
				self.RutharEye.State = 6
			end
		end
		if self.RutharEye.State == 1 or self.RutharEye.State == 4 then -- do spotting
			if ClawInLOS(self) then
				self.RutharEye.State = 5
				if not isLookingAtClaw(self) then
					SwitchDirection(self)
				end
				if rand() > 0.5 then
					PlaySound("CUSTOM_TRIGGER_EYE2ANGRY1")
				else
					PlaySound("CUSTOM_TRIGGER_EYE2ANGRY2")
				end
				--TextOut(self.RutharEye.State)
			end
		end
		if self.ID == 1361 and self.RutharEye.State ~= 0 then
			if self.MrHat == nil then
				self.MrHat = CreateObject {x=self.X, y=self.BaseY+getFloatingYModifier(self)-16, z=4200, name = "MrHat", logic="CustomLogic", image="CUSTOM_MRHAT"}
			else
				self.MrHat.X = self.X
				self.MrHat.Y = self.BaseY + getFloatingYModifier(self) - 16
				
			end
		end
		--TextOut(self.RutharEye.State .. ", " .. self.Boredom .. ", " .. self.XDestination)
	end
	if self.sensorLFlag == 0 then
		if self.sensorL.Collision == 1 then
			self.rangeL = self.sensorL.CollisionX
			self.sensorLFlag = 1
			self.sensorL:Destroy()
		end
	end
	if self.sensorRFlag == 0 then
		if self.sensorR.Collision == 1 then
			self.rangeR = self.sensorR.CollisionX
			self.sensorRFlag = 1
			self.sensorR:Destroy()
		end
	end
	if self.sensorLFlag == 1 and self.sensorRFlag == 1 then
		self.Flags.AlwaysActive = false
		--TextOut(self.rangeL .. ", " .. self.rangeR)
	end
	local claw = GetClaw()
	--if claw.Y > self.RutharEye.Y - 12 and claw.Y < self.RutharEye.Y - 24
	--TextOut(self.RutharEye.State)
	--TextOut(self.REY)
	
	if self.RutharEye.Health <= 0 then
		if self.Flag6 == 0 then
			self.Flag6 = 1
			self.Achievements.ReKills = self.Achievements.ReKills + 1
		end
		if self.Speed == 2 and self.Flag8 == 0 then
			self.Flag8 = 1
			self.Achievements.MutantKills = self.Achievements.MutantKills + 1
		end
		if self.ID == 1361 then
			self.Achievements.Klementynka = 1
			if self.MrHat ~= nil then
				self.MrHat.State = 2
			end
		end
		if self.RutharEye.Health == -99 then
			if self.ID == 2932 or self.ID == 2934 or self.ID == 2967 or self.ID == 2968 or self.ID == 2980 or self.ID == 2981 then
				self.RutharEye.Health = -101
				self.Achievements.VentKills = self.Achievements.VentKills + 1
			end
		end
		
		--TextOut(self.RutharEye.Y)
		self.rcore = CreateObject {x=self.REX, y=self.REY, z=3900, name="RutharCore", logic="CustomLogic", image="CUSTOM_RUTHARCOREBLUE", SpeedY = self.Y-32, UserRect1 = self.UserRect1, UserRect2 = self.UserRect2, Powerup = self.Powerup}
		CreateObject {x=self.REX, y=self.REY, z=3950, name="Explosion", logic="CustomLogic", image="CUSTOM_EXPLOSION"}
		PlaySound("CUSTOM_TRIGGER_BURNING1")
		if self.Smarts == 1 then
			self.rcore.Flags.AlwaysActive = true
			if self.Flag7 == 0 then
				self.Flag7 = 1
				self.Achievements.ShootKills = self.Achievements.ShootKills + 1
			end
		end
		
		local cm = GetObject(4219)
		if cm.UnnaturalHunger == true then
			local claw = GetClaw()
			if claw.Health > 0 then
				claw.Health = claw.Health + 5
				cm.lastHP = claw.Health
			end
		end
		
		self.RutharEye.State = 2
		self.RutharEye.DrawFlags.NoDraw = true
		if self.rcore.Y > 0 then
			self.RutharEye:Destroy()
			self.RutharEye = nil
			self:Destroy()
		end
	end
	
	if self.RutharEye ~= nil then
		if self.RutharEye.Y > 0 and self.RutharEye.Y < 12000 then
			self.REX = self.RutharEye.X
			self.REY = self.RutharEye.Y
		end
	end
end